# -*- coding: utf-8 -*-
#Chorder
#http://www.chorder.net
#binanary to hex


import os
import sys
import getopt
import string

def text_output(file, data_list, sp):
	output = open(file, 'w+')
	for count in range(0, len(data_list)):
		if count%sp==0:
			output.write('\n')
		output.write(data_list[count])
	output.close()

def bin_read(file):
	data_list = []
	f = open(file, 'rb')
	f.seek(0, 0)
	while True:
		byte = f.read(1)
		if len(byte) == 0:
			break
		else:
			data_list.append("\\x%.2X" % ord(byte))
	return data_list

def help():
	print u'\n选项:\n-h --help\t查看此帮助\n-i --input\t指定二进制文件\n-o --output\t输出到文本\n-s --sp\t\t指定每行的单元个数'
	
def main(argv):
	opts, args = getopt.getopt(argv[1:], 'hi:o:s:', ['help','input=', 'output=', 'sp='])
	for act, obj in opts:
		if act in ("-h","--help"):
			help()
			sys.exit(0)
		if act in ("-i","--input"):
			input = obj

		if act in ("-o","--output"):
			output = obj
		else:
			output = 0
		if act in ("-s","--split"):
			sp = string.atoi(obj)
		else:
			sp = 15
			
	try:
		data_list = bin_read(input)
		for count in range(0, len(data_list)):
			if count%sp== 0:
				sys.stdout.write("\n")
			sys.stdout.write(data_list[count])
		
		if output != 0:
			text_output( output, data_list, sp )
	except Exception,e:
		help()
		sys.exit(0)
		
if __name__ == '__main__':
	main(sys.argv)
